import { NextRequest, NextResponse } from 'next/server';

export function clearNextAuthCookies(request: NextRequest, response: NextResponse) {
  const cookieNames = [
    'next-auth.session-token',
    '__Secure-next-auth.session-token',
    'next-auth.csrf-token',
    '__Host-next-auth.csrf-token',
    'next-auth.callback-url',
    '__Secure-next-auth.callback-url'
  ];

  cookieNames.forEach(cookieName => {
    response.cookies.delete(cookieName);
  });

  return response;
}

export function isJWTError(error: unknown): boolean {
  const err = error as { name?: string; message?: string; code?: string };
  return err?.name === 'JWEDecryptionFailed' || 
         err?.message?.includes('decryption operation failed') ||
         err?.code === 'JWT_SESSION_ERROR';
}