'use client';

import { SessionProvider } from 'next-auth/react';
import { Session } from 'next-auth';
import { useEffect } from 'react';
import { signOut } from 'next-auth/react';

interface SessionProviderWrapperProps {
  children: React.ReactNode;
  session: Session | null;
}

export function SessionProviderWrapper({ children, session }: SessionProviderWrapperProps) {
  useEffect(() => {
    // Handle JWT errors by clearing session
    const handleUnhandledRejection = (event: PromiseRejectionEvent) => {
      if (event.reason?.name === 'JWEDecryptionFailed' || 
          event.reason?.message?.includes('decryption operation failed')) {
        console.warn('JWT decryption failed, signing out...');
        signOut({ callbackUrl: '/login' });
      }
    };

    window.addEventListener('unhandledrejection', handleUnhandledRejection);
    
    return () => {
      window.removeEventListener('unhandledrejection', handleUnhandledRejection);
    };
  }, []);

  return (
    <SessionProvider 
      session={session}
      refetchInterval={5 * 60} // Refetch session every 5 minutes
      refetchOnWindowFocus={true}
    >
      {children}
    </SessionProvider>
  );
}