'use client';

import Link from 'next/link';
import { usePathname } from 'next/navigation';
import { 
  LayoutDashboard, 
  Users, 
  Briefcase, 
  UserCheck, 
  Settings, 
  Package, 
  Globe, 
  Languages,
  MapPin,
  LogOut 
} from 'lucide-react';
import { signOut } from 'next-auth/react';

const menuItems = [
  {
    title: 'Dashboard',
    href: '/dashboard',
    icon: LayoutDashboard,
  },
  {
    title: 'Clients',
    href: '/clients',
    icon: Users,
  },
  {
    title: 'Freelancers',
    href: '/freelancers',
    icon: UserCheck,
  },
  {
    title: 'Projects',
    href: '/projects',
    icon: Briefcase,
  },
  // {
  //   title: 'Packages',
  //   href: '/packages',
  //   icon: Package,
  // },
  {
    title: 'Domains',
    href: '/domains',
    icon: Globe,
  },
  {
    title: 'Languages',
    href: '/languages',
    icon: Languages,
  },
  {
    title: 'Countries',
    href: '/countries',
    icon: MapPin,
  },
  {
    title: 'Site Settings',
    href: '/settings',
    icon: Settings,
  },
];

export default function Sidebar() {
  const pathname = usePathname();

  return (
    <div className="bg-gray-900 text-white w-64 min-h-screen h-full flex flex-col max-md:hidden sidebar-wrapper max-md:overflow-auto">
      <div className="p-6 border-b border-gray-700">
        <h1 className="text-xl font-bold text-blue-400">Smile24 Admin</h1>
      </div>
      
      <nav className="flex-1 p-4">
        <ul className="space-y-2">
          {menuItems.map((item) => {
            const Icon = item.icon;
            const isActive = pathname === item.href;
            
            return (
              <li key={item.href}>
                <Link
                  href={item.href}
                  className={`flex items-center space-x-3 px-4 py-3 rounded-lg transition-colors max-md:text-sm ${
                    isActive
                      ? 'bg-blue-600 text-white'
                      : 'text-gray-300 hover:bg-gray-800 hover:text-white'
                  }`}
                >
                  <Icon size={20} />
                  <span>{item.title}</span>
                </Link>
              </li>
            );
          })}
        </ul>
      </nav>
      
      <div className="p-4 border-t border-gray-700">
        <button
          onClick={() => signOut()}
          className="flex items-center space-x-3 px-4 py-3 rounded-lg text-gray-300 hover:bg-gray-800 hover:text-white transition-colors w-full max-md:text-sm"
        >
          <LogOut size={20} />
          <span>Logout</span>
        </button>
      </div>
    </div>
  );
}