'use client';

import { useState, useEffect } from 'react';
import { useSession } from 'next-auth/react';
import { Bell, User, Menu, X } from 'lucide-react';

export default function Header() {
  const { data: session } = useSession();
  const [isSidebarOpen, setIsSidebarOpen] = useState(false);

  // ✅ Toggle sidebar class on body or specific element
  useEffect(() => {
    const sidebar = document.querySelector('.sidebar-wrapper');
    const body = document.querySelector('body');
    if (sidebar && body) {
      if (isSidebarOpen) {
        sidebar.classList.add('open');
        body.classList.add('sidebar-open');
      } else {
        sidebar.classList.remove('open');
        body.classList.remove('sidebar-open');
      }
    }
  }, [isSidebarOpen]);

  return (
    <header className="bg-white shadow-sm border-b border-gray-200 px-6 py-4 max-md:px-3">
      <div className="flex items-center justify-between">
        <div className="flex items-center space-x-3">
          <div>
            <h2 className="text-xl font-semibold text-gray-800 max-lg:text-lg">
              Admin Panel
            </h2>
            <p className="text-sm text-gray-600 max-sm:hidden">Manage your Smile24 platform</p>
          </div>
        </div>

        <div className="flex items-center space-x-4">
          {/* <button className="p-2 hover:bg-gray-100 rounded-lg transition-colors">
            <Bell size={20} className="text-gray-600" />
          </button> */}

          <div className="flex items-center space-x-2 border-l border-gray-200 pl-4 max-sm:pl-2">
            <div className="w-8 h-8 bg-blue-500 rounded-full flex items-center justify-center">
              <User size={16} className="text-white" />
            </div>
            <div>
              <p className="text-sm font-medium text-gray-800">
                {session?.user?.email || 'Admin'}
              </p>
              <p className="text-xs text-gray-600">Administrator</p>
            </div>
          </div>

          <button className="md:hidden p-1 pr-0 rounded-md hover:bg-gray-100 transition hamburger-bar" onClick={() => setIsSidebarOpen(!isSidebarOpen)}>
            {isSidebarOpen ? (
              <X size={24} className="text-gray-800" />
            ) : (
              <Menu size={24} className="text-gray-800" />
            )}
          </button>
        </div>
      </div>
    </header>
  );
}
