 
import { NextRequest, NextResponse } from "next/server";
import { prisma } from "@/lib/prisma";

export async function PUT(req: NextRequest) {
  try {
    const body = await req.json();

    if (!body.id)
      return NextResponse.json(
        { error: "Country ID is required" },
        { status: 400 }
      );

    const updatedCountry = await prisma.country.update({
      where: { id: body.id },
      data: {
        businessEmail: body.businessEmail,
        mapIframe: body.mapIframe,

        ...Object.fromEntries(
          ["en", "fr", "de", "it", "pt", "es"].flatMap((lang) => [
            [`location_${lang}`, body[`location_${lang}`]],
            [`sublocation_${lang}`, body[`sublocation_${lang}`]],
            [`shortDescription_${lang}`, body[`shortDescription_${lang}`]],
          ])
        ),
        customerPhone:body?.customerPhone,
        facebookUrl: body.facebookUrl,
        googleUrl: body.googleUrl,
        instagramUrl: body.instagramUrl,
        linkedinUrl: body.linkedinUrl,
        twitterUrl: body.twitterUrl,
        logoFooter: body.logoFooter,
        logoHeader: body.logoHeader,
        supportEmail: body.supportEmail,
      },
    });

    return NextResponse.json(updatedCountry);
  } catch (err) {
    console.error(err);
    return NextResponse.json(
      { error: "Failed to update country" },
      { status: 500 }
    );
  }
}
