#!/usr/bin/env node

const fs = require('fs');
const path = require('path');

console.log('🔧 Clearing NextAuth session data...\n');

// Clear Next.js build cache
const nextDir = path.join(__dirname, '.next');
if (fs.existsSync(nextDir)) {
  fs.rmSync(nextDir, { recursive: true, force: true });
  console.log('✅ Cleared .next build cache');
}

// Clear node_modules cache (optional)
const nodeModulesCache = path.join(__dirname, 'node_modules/.cache');
if (fs.existsSync(nodeModulesCache)) {
  fs.rmSync(nodeModulesCache, { recursive: true, force: true });
  console.log('✅ Cleared node_modules cache');
}

console.log('\n🎯 Session cleanup complete!');
console.log('\nTo complete the fix:');
console.log('1. Clear your browser cookies for localhost:3000');
console.log('2. Restart your development server: npm run dev');
console.log('3. Try logging in again');
console.log('\nIf you continue to have issues, make sure NEXTAUTH_SECRET is properly set in .env.local');