# Smile24 Admin Panel

A modern, responsive admin panel built with Next.js, TypeScript, and Tailwind CSS for managing the Smile24 freelance platform.

## Features

### 🔐 Authentication & Security
- Admin-only authentication with NextAuth.js
- Protected routes and middleware
- Role-based access control

### 📊 Dashboard
- Real-time statistics and metrics
- Interactive charts and graphs (Recharts)
- Date filtering and domain filtering
- Recent activities tracking

### 👥 User Management
- View and manage all platform users
- Filter by role (Client, Freelancer, Admin)
- Filter by domain and date range
- User profile management
- Subscription status tracking

### 📋 Project Management
- Complete project overview
- Status tracking (Draft, Open, In Progress, Completed, Cancelled)
- Budget and timeline management
- Bid monitoring
- Client and category filtering

### 👨‍💼 Freelancer Management
- Freelancer profile oversight
- Verification management
- Skills and rating tracking
- Performance analytics

### 💰 Package & Pricing Management
- Edit pricing for subscription packages
- Country-specific package management
- Feature configuration
- Active/inactive status control

### 🌍 Domain Management
- Manage country domains (10 initially, expandable)
- Currency and language settings
- Payment gateway configuration
- Domain activation/deactivation

### 🌐 Language Management
- Manage 6 languages (initially)
- Active/inactive language control
- Only active languages show in frontend
- Easy language activation toggle

### ⚙️ Site Settings
- Site title and logo management
- Social media links configuration
  - Facebook
  - Instagram
  - LinkedIn
  - Twitter
- Contact information
- System settings

## Technology Stack

- **Frontend**: Next.js 15 with App Router
- **Language**: TypeScript
- **Styling**: Tailwind CSS
- **Authentication**: NextAuth.js
- **Database**: MySQL with Prisma ORM
- **Charts**: Recharts
- **Icons**: Lucide React

## Installation & Setup

### Prerequisites
- Node.js 18+ 
- MySQL database
- npm or yarn

### 1. Clone and Install
```bash
cd smile24-admin
npm install
```

### 2. Environment Configuration
Create a `.env.local` file:
```env
DATABASE_URL="mysql://username:password@localhost:3306/smile24_admin"
NEXTAUTH_SECRET="your-secret-key-here"
NEXTAUTH_URL="http://localhost:3000"
```

### 3. Database Setup
```bash
# Generate Prisma client
npx prisma generate

# Run database migrations
npx prisma db push

# Optional: Seed the database
npx prisma db seed
```

### 4. Create Admin User
You'll need to create an admin user in your database with `role = 'ADMIN'` and a hashed password.

### 5. Run Development Server
```bash
npm run dev
```

Visit `http://localhost:3000` to access the admin panel.

## Project Structure

```
src/
├── app/                    # Next.js App Router
│   ├── dashboard/         # Dashboard page
│   ├── users/            # User management
│   ├── projects/         # Project management
│   ├── freelancers/      # Freelancer management
│   ├── packages/         # Package management
│   ├── domains/          # Domain management
│   ├── languages/        # Language management
│   ├── settings/         # Site settings
│   └── login/            # Authentication
├── components/           # Reusable components
│   ├── Sidebar.tsx       # Navigation sidebar
│   ├── Header.tsx        # Top header
│   ├── DashboardLayout.tsx
│   └── ProtectedRoute.tsx
├── lib/                  # Utilities
│   ├── auth.ts          # NextAuth configuration
│   └── prisma.ts        # Prisma client
└── types/               # TypeScript types
```

## Key Features Implemented

### Dashboard
- ✅ Statistics cards with user, project, and revenue metrics
- ✅ Interactive charts for monthly data
- ✅ Date range filtering
- ✅ Domain filtering
- ✅ Recent activities feed

### User Management
- ✅ User listing with pagination
- ✅ Search functionality
- ✅ Role and domain filters
- ✅ Subscription status display
- ✅ User actions (view, edit, delete)

### Project Management
- ✅ Project listing with comprehensive filters
- ✅ Status management
- ✅ Budget and timeline tracking
- ✅ Bid monitoring
- ✅ Client and category information

### Package Management
- ✅ Visual package cards
- ✅ Price editing functionality
- ✅ Feature management
- ✅ Country-specific packages
- ✅ Active/inactive status

### Site Settings
- ✅ General site configuration
- ✅ Social media links management
- ✅ Contact information
- ✅ System settings
- ✅ Logo upload interface

### Domain & Language Management
- ✅ Domain configuration
- ✅ Language activation/deactivation
- ✅ Currency and payment gateway settings

## Development Notes

### Authentication Flow
1. Admin logs in through `/login`
2. NextAuth.js validates credentials against database
3. Session includes user role
4. Middleware protects all routes except login
5. Components use `useSession` for auth state

### Data Flow
- Mock data is used throughout for demonstration
- Replace API calls in `useEffect` hooks with actual endpoints
- All components are designed for real API integration

### Responsive Design
- Mobile-first approach with Tailwind CSS
- Responsive navigation and layouts
- Optimized for desktop admin use

## Future Enhancements

- [ ] Real API integration
- [ ] Advanced filtering and search
- [ ] Bulk operations
- [ ] Export functionality
- [ ] Real-time notifications
- [ ] Audit logging
- [ ] Advanced analytics
- [ ] Multi-language admin interface

## Security Considerations

- Admin-only access with role verification
- Protected API routes
- Input validation and sanitization
- Secure password handling
- Session management with NextAuth.js

## Support

For technical support or questions about the admin panel implementation, please refer to the documentation or contact the development team.

---

Built with ❤️ for the Smile24 platform